/* create OLTP write workload stored procedures for InterBase */

/* ---------- */
/* ---------- */

set term ^^ ;

/*
-- procedure oltp_write_01 (randbase)
-- increment randomly chosen updates.p_int by 1 and save old row in update_int_history
-- changes: updates.p_int, update_int_history
-- might use index on: updates.p_key
-- competes with: oltp_read_select_04, oltp_read_select_05, oltp_read_select_06, oltp_write_06
-- checks atomicity, asolation
-- single table 1 row select and update on an int, 1 row insert
*/

drop procedure oltp_write_01 ^^
drop exception oltp_write_01_error ^^
create exception oltp_write_01_error 'Error in oltp_write_01.' ^^
create procedure oltp_write_01 (randbase int) as
declare variable
	oldint	int;
begin
/*	set transaction isolation level snapshot; */

	select updates.p_int
		from updates
		where updates.p_key = :randbase
		into oldint;
	update updates set updates.p_int = updates.p_int + 1
		where updates.p_key = :randbase;
	insert into update_int_history values (:randbase, :oldint, 'now');
	exit;

when any do
	exception oltp_write_01_error;
end ^^

/* -- */

drop procedure oltp_write_01_check ^^
create procedure oltp_write_01_check returns (msg varchar(80)) as
declare	variable
	checkval1	float;
declare	variable
	count_update_int_history	float;
declare	variable
	checkval2	float;
begin
	select sum(updates.p_int) from updates
		into checkval1;
	select count(*) from update_int_history
		into count_update_int_history;
	checkval1 = checkval1 - count_update_int_history;
	select int_sum from oltp_write_01_check_value
		into checkval2;
/*	select 'oltp_write_01_check should return two identical values. The actual values are ', :checkval1, :checkval2 from rdb$database into :msg, :checkval1out, :checkval2out; */
	if (checkval1 = checkval2) then
		select 'Consistency check passed in oltp_write_01.' from rdb$database into :msg;
	else
		select '**CONSISTENCY CHECK FAILURE** in oltp_write_01.' from rdb$database into :msg;
end ^^

/* -- */

drop procedure oltp_write_01_undo ^^
create procedure oltp_write_01_undo returns (msg varchar(80)) as
begin
        update updates
                set p_int = p_key
                where updates.p_int <> updates.p_key;
        delete from update_int_history;
        select 'Finished undoing effects of oltp_write_01.' from rdb$database into :msg;
end ^^

/* ---------- */

/*
-- procedure oltp_write_02 (randbase)
-- increment randomly chosen updates.p_signed by 1 and save old row in update_signed_history
-- changes: updates.p_signed, update_signed_history
-- might use index on: updates.p_key
-- competes with oltp_read_select_04, oltp_read_select_05, oltp_read_select_06, oltp_read_join_03
-- checks atomicity, isolation
-- single table 1 row select and update on an int, 1 row insert
*/

drop procedure oltp_write_02 ^^
drop exception oltp_write_02_error ^^
create exception oltp_write_02_error 'Error in oltp_write_02.' ^^
create procedure oltp_write_02 (randbase int) as
declare variable
        oldsigned      int;
begin
/*	set transaction isolation level snapshot; */

	select updates.p_signed
		from updates
		where updates.p_key = :randbase
		into oldsigned;
	update updates set updates.p_signed = updates.p_signed + 1
		where updates.p_key = :randbase;
	insert into update_signed_history values (:randbase, :oldsigned, 'now');
	exit;

when any do
	exception oltp_write_02_error;
end ^^

/* -- */

drop procedure oltp_write_02_check ^^
create procedure oltp_write_02_check returns (msg varchar(80)) as
declare	variable
	checkval1	float;
declare	variable
	checkval2	float;
begin
	select sum(updates.p_signed) from updates
		into checkval1;
	select count(*) from update_signed_history
		into checkval2;
/*	select 'oltp_write_02_check should return two identical values (the number of times oltp_write_02 has been run). The actual values are ', :checkval1, :checkval2 from rdb$database into :msg, :checkval1out, :checkval2out; */
	if (checkval1 = checkval2) then
		select 'Consistency check passed in oltp_write_02.' from rdb$database into :msg;
	else
		select '**CONSISTENCY CHECK FAILURE** in oltp_write_02.' from rdb$database into :msg;
end ^^

/* -- */

drop procedure oltp_write_02_undo ^^
create procedure oltp_write_02_undo returns (msg varchar(80)) as
declare variable
	oldkey	int;
declare variable
        oldsigned	int;
/* declare variable
	update_cursor cursor for
		select updates.p_key, update_signed_history.p_signed
		from updates, update_signed_history
		where updates.p_key = update_signed_history.p_key
		and update_signed_history.p_signed in
			(select min(update_signed_history.p_signed)
			from update_signed_history, updates
			where update_signed_history.p_key = updates.p_key
			group by update_signed_history.p_key); */
begin
/*	open update_cursor;
	fetch update_cursor into oldkey, oldsigned;
	while (sqlcode <> 0) do
	begin
		update updates
			set updates.p_signed = :oldsigned
			where updates.p_key = :oldkey;
		fetch update_cursor into oldkey, oldsigned;
	end; */
        delete from update_signed_history;
        select 'Finished undoing effects of oltp_write_02.' from rdb$database into :msg;
end ^^

/* ---------- */

/*
-- procedure oltp_write_03 (randfivemill)
-- moves a randomly selected row from fivemill to del_history
-- changes: fivemill, del_history
-- might use index on: fivemill.h_key
-- competes with oltp_read_join_03
-- checks atomicity, isolation
-- single row select and insert, single row delete
*/

drop procedure oltp_write_03 ^^
drop exception oltp_write_03_error ^^
create exception oltp_write_03_error 'Error in oltp_write_03.' ^^
create procedure oltp_write_03 (randfivemill int) as
begin
/*	set transaction isolation level snapshot; */

	insert into del_history
		select * from fivemill where fivemill.h_key = :randfivemill;
	delete from fivemill
		where fivemill.h_key = :randfivemill;
	exit;

when any do
	exception oltp_write_03_error;
end ^^

/* -- */

drop procedure oltp_write_03_check ^^
create procedure oltp_write_03_check returns (msg varchar(80)) as
declare	variable
	checkval1	int;
declare	variable
	checkval2	int;
begin
	select count(*) from fivemill into checkval1;
	select count(*) from del_history into checkval2;
/*	select 'oltp_write_03_check should return exactly 5,000,000. The actual value is ', :checkval1 + :checkval2 from rdb$database into :msg; */
	if (checkval1 + checkval2 = 50000) then
		select 'Consistency check passed in oltp_write_03.' from rdb$database into :msg;
	else
		select '**CONSISTENCY CHECK FAILURE** in oltp_write_03.' from rdb$database into :msg;
end ^^

/* -- */

drop procedure oltp_write_03_undo ^^
create procedure oltp_write_03_undo returns (msg varchar(80)) as
begin
	insert into fivemill select * from del_history;
	delete from del_history;
        select 'Finished undoing effects of oltp_write_03.' from rdb$database into :msg;
end ^^

/* ---------- */

/*
-- procedure oltp_write_04 (randfourmill)
-- modifies between 1 and 2 randomly chosen fourmill.t_name and fourmill.t_address values, increments the update counter oltp_write_04_count_updates.num_updates
-- changes: fourmill.t_name, fourmill.t_address, oltp_write_04_count_updates.num_updates
-- might use index on: fourmill.t_key
-- competes with nothing else
-- checks atomicity
-- single table in range select and update on 2 character fields, 1 int field
*/

drop procedure oltp_write_04 ^^
drop exception oltp_write_04_error ^^
create exception oltp_write_04_error 'Error in oltp_write_04.' ^^
create procedure oltp_write_04 (randfourmill int) as
declare variable
	numupdates	int;
begin
/*	set transaction isolation level snapshot; */

	select count(*) from fourmill
		where (fourmill.t_key between :randfourmill and :randfourmill + 500)
		and (fourmill.t_name <> 'NewName')
		into numupdates;
	update fourmill
		set fourmill.t_name = 'NewName', fourmill.t_address = 'New Address 320B Lakeside Dr., Foster City, CA'
		where (fourmill.t_key between :randfourmill and :randfourmill + 500)
		and (fourmill.t_name <> 'NewName');
	update oltp_write_04_count_updates
		set oltp_write_04_count_updates.num_updates = oltp_write_04_count_updates.num_updates + :numupdates;
	exit;

when any do
	exception oltp_write_04_error;
end ^^

/* -- */

drop procedure oltp_write_04_check ^^
create procedure oltp_write_04_check returns (msg varchar(80)) as
declare	variable
	checkval1	int;
declare	variable
	checkval2	int;
begin
	select count(*) from fourmill
		where fourmill.t_name = 'NewName'
		into checkval1;
	select num_updates from oltp_write_04_count_updates
		into checkval2;
/*	select 'oltp_write_04_check should return two identical values. The actual values are ', :checkval1, :checkval2 from rdb$database into :msg; */

	if (checkval1 = checkval2) then
		select 'Consistency check passed in oltp_write_04.' from rdb$database into :msg;
	else
		select '**CONSISTENCY CHECK FAILURE** in oltp_write_04.' from rdb$database into :msg;
end ^^

/* -- */

drop procedure oltp_write_04_undo ^^
create procedure oltp_write_04_undo returns (msg varchar(80)) as
begin
	update fourmill
		set fourmill.t_name = 'OldName'
		where fourmill.t_name = 'NewName' and fourmill.t_address = 'New Address 320B Lakeside Dr., Foster City, CA';
	update oltp_write_04_count_updates
		set oltp_write_04_count_updates.num_updates = 0;
        select 'Finished undoing effects of oltp_write_04.' from rdb$database into :msg;
end ^^

/* ---------- */

/*
-- procedure oltp_write_05 (randbase)
-- does an update on 10 contiguous rows of updates.p_decim and then rolls the changes back
-- changes: (nothing)
-- might use index on updates.p_key 
-- competes with oltp_write_06, dss_select_05, dss_select_06, dss_select_07, dss_select_08, dss_select_09
-- checks atomicity, consistency, isolation
-- single table range update and rollback
*/

drop procedure oltp_write_05 ^^
drop exception oltp_write_05_error ^^
create exception oltp_write_05_error 'Error in oltp_write_05.' ^^
create procedure oltp_write_05 (randbase int) as
begin
/*	set transaction isolation level snapshot; */

	update updates
		set updates.p_decim = updates.p_decim - 2000000001
		where updates.p_key between :randbase and :randbase + 9;
/*	rollback; */
	exception oltp_write_05_error;
	exit;

when any do
	exception oltp_write_05_error;
end ^^

/* -- */

drop procedure oltp_write_05_check ^^
create procedure oltp_write_05_check returns (msg varchar(80)) as
declare	variable
	checkval1	int;
begin
	select count(*) from updates
		where updates.p_decim < -1000000000
		into checkval1;
/*	select 'oltp_write_05_check should return exactly 0. The actual value is ', :checkval1 from rdb$database into :msg; */

	if (checkval1 = 0) then
		select 'Consistency check passed in oltp_write_05.' from rdb$database into :msg;
	else
		select '**CONSISTENCY CHECK FAILURE** in oltp_write_05.' from rdb$database into :msg;
end ^^

/* -- */

drop procedure oltp_write_05_undo ^^
create procedure oltp_write_05_undo returns (msg varchar(80)) as
begin
	/* procedure is self-undoing */
        select 'Finished undoing effects of oltp_write_05.' from rdb$database into :msg;
end ^^

/* ---------- */

set term ; ^^
